local PANEL = {};

// arrow material
local arrow = surface.GetTextureID( "gui/arrow" );

// create a font.
surface.CreateFont( "coolvetica", 32, 500, true, false, "RotationText" );

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// init
function PANEL:Init( )
	// linked calss
	self.LinkedClass = nil;
	
	// vars
	self.Rotation = 45;
	self.Grabbed = false;
	self.Highlight = false;
	self.SnapsTo	= 15;
	self.ConVar = nil;
	self.LastValue = 45;
	self.NextConVarCheck = CurTime() + 2;
	
	// vars.
	self.Color = Color( 0, 0, 0, 128 );
	self.Text = "Pitch";
	
end


// convar check
function PANEL:Think( )
	// dont' do shit unless we're attached to a convar.
	if( !self.ConVar ) then return; end

	// time to update?
	if( self.NextConVarCheck <= CurTime() && !self.Grabbed ) then
		// next
		self.NextConVarCheck = CurTime() + 2;
		
		// update.
		local val = GetConVarNumber( self.ConVar );
		
		// differs?
		if( self.Rotation != val ) then
			self.Rotation = val;
			self.LastValue = val;
		
		end
	
	end
	
end


// set convar.
function PANEL:SetConVar( v )
	self.ConVar = v;

end


// paint.
function PANEL:OnMousePressed( mc )
	// mousey mousey mousey!
	local x, y = gui.MousePos();
	x, y = self:ScreenToLocal( x, y );

	// knob coords.
	local ofs = self:GetWide() * 0.5;
	local wx = ofs + ( ( ofs - 10 ) * math.cos( math.rad( self.Rotation ) ) );
	local wy = ofs + ( ( ofs - 10 ) * math.sin( math.rad( self.Rotation ) ) );

	// mouse within knob boundries?
	if( x > wx - 16 && x < wx + 16 &&
		y > wy - 16 && y < wy + 16 ) then
		// start grab.
		self.Grabbed = true;
		
		// capture the mouse
		self:MouseCapture( true );
		
	end
	
end

// mouse released
function PANEL:OnMouseReleased( mc )
	// release mouse
	self:MouseCapture( false );
	
	// stop grab
	self.Grabbed = false;

end

// cursor enter
function PANEL:OnCursorEntered( )
	self.Highlight = true;
end

function PANEL:OnCursorExited( )
	self.Highlight = false;
	
end


// cursor moved.
function PANEL:OnCursorMoved( x, y )
	// dragging?
	if( !self.Grabbed ) then return; end
	
	// center.
	local ofs = self:GetWide() * 0.5;
	local wx = ofs;
	local wy = ofs;
	
	// calculate angle.
	self.Rotation = math.floor( math.deg( math.atan2( y - wy, x - wx ) ) );			
	if( self.Rotation < 0 ) then self.Rotation = self.Rotation + 360; end
	if( self.Rotation > 360 ) then self.Rotation = self.Rotation - 360; end
	
	// snap rotation.
	self.Rotation = self.Rotation - math.fmod( self.Rotation, self.SnapsTo );
	
	// our value changed?
	if( self.LastValue != self.Rotaion ) then
		self.LastValue = self.Rotation;
			
		// convar?
		if( self.ConVar ) then
			LocalPlayer():ConCommand( self.ConVar .. " " .. self.Rotation .. "\n" );
		
		end
		
		// call event.
		if( self.LinkedClass ) then
			self.LinkedClass:CallEvent( "OnRotationChanged", self.Rotation );
		
		end
	
	end
	
end


// draw poly circle
function PANEL:DrawPolyCircle( x, y, radius, color, degrees, resolution )
	// initial point.
	local verts = {
		[1] = {
			x = x,
			y = y,
		},
	};
	
	// calculate vars.
	local degrees = ( resolution / 360 ) * degrees;

	// set poly.
	local i;
	for i = 0, degrees do
		// based on resolution.
		local ang = ( 360 / resolution ) * i;
		
		// calculate pos.
		local vert = {
			x = x + ( radius * math.cos( math.rad( ang ) ) ),
			y = y + ( radius * math.sin( math.rad( ang ) ) ),
		};
		
		// add
		table.insert( verts, vert );
	
	end
	
	// draw.
	surface.SetDrawColor( color.r, color.g, color.b, color.a );
	surface.DrawPoly( verts );

end


// paint
function PANEL:Paint( )
	// for some reasont he texture is being carried into this function.
	draw.NoTexture();
	
	// center.
	local ofs = ( self:GetWide() - 20 ) * 0.5;
	local wx = ofs + 10;
	local wy = ofs + 10;
	
	// draw border.
	self:DrawPolyCircle(
		wx, wy,
		ofs + 4,
		AppFramework:Theme().colors['border_light'],
		360,
		32
	);
	
	// draw facing
	self:DrawPolyCircle(
		wx, wy,
		ofs + 3,
		Color( self.Color.r * 0.5, self.Color.g * 0.5, self.Color.b * 0.5, 255 ),
		360,
		32
	);
	
	// draw bulk
	self:DrawPolyCircle(
		wx, wy,
		ofs,
		self.Color,
		self.Rotation,
		180
	);
	
	// draw rotation lines.
	local i;
	for i = 0, 360, 15 do
		// calculate start and endpos.
		local x1 = wx + ofs * math.cos( math.rad( i ) );
		local y1 = wy + ofs * math.sin( math.rad( i ) );
		local x2 = wx + ( ofs * 0.75 ) * math.cos( math.rad( i ) );
		local y2 = wy + ( ofs * 0.75 ) * math.sin( math.rad( i ) );
		
		// draw
		surface.SetDrawColor( 0, 0, 0, 90 );
		surface.DrawLine(
			x1, y1,
			x2, y2
		);
	
	end
	
	// draw text
	surface.SetFont( "TargetIDSmall" );
	local w, h = surface.GetTextSize( "A" );
	draw.SimpleText(
		self.Text,
		"TargetIDSmall",
		wx, wy,
		Color( 255, 255, 255, 255 ),
		TEXT_ALIGN_CENTER,
		TEXT_ALIGN_CENTER
	);
	draw.SimpleText(
		tostring( self.Rotation ),
		"TargetID",
		wx, wy + h + 1,
		Color( 255, 255, 255, 255 ),
		TEXT_ALIGN_CENTER,
		TEXT_ALIGN_CENTER
	);
	
	// draw the selector arrow.
	local delta = 0;
	if( self.Highlight ) then delta = 128; end

	// draw arrow.
	surface.SetTexture( arrow );
	surface.SetDrawColor( 255, 255, 255, 127 + delta );
	surface.DrawTexturedRectRotated(
		wx + ofs * math.cos( math.rad( self.Rotation ) ),
		wy + ofs * math.sin( math.rad( self.Rotation ) ),
		24, 24,
		( 360 - self.Rotation ) + 90
	);
	
	//
	return true;
	
end

// get/set value
function PANEL:GetValue( )
	return self.Rotation;

end
function PANEL:SetValue( v )
	self.Rotation = v;

end

//set text
function PANEL:SetText( text )
	self.Text = text;

end

// set color
function PANEL:SetColor( c )
	self.Color = c;

end


// register
vgui.Register( "ctl_rotationgizmo", PANEL, "Panel" );



// create app framework control.
CtlRotationGizmo_class 	= Control_class:create( nil, false, "ctl_rotationgizmo" );

// set value
function CtlRotationGizmo_class:SetValue( v )
	self:GetHandle():SetValue( v );
	
end


// get value
function CtlRotationGizmo_class:GetValue( )
	return self:GetHandle():GetValue();
	
end

// set value
function CtlRotationGizmo_class:SetText( v )
	self:GetHandle():SetText( v );
	
end

// set value
function CtlRotationGizmo_class:SetConVar( v )
	self:GetHandle():SetConVar( v );
	
end

// set value
function CtlRotationGizmo_class:SetColor( v )
	self:GetHandle():SetColor( v );
	
end

